﻿using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.IO;
using Boare.Lib.Vsq;
using Boare.Cadencii;
using Boare.Lib.Media;
using bocoree;

public class Pitch_and_Volume_Adjuster : System.Windows.Forms.Form {
    private int m_clock_resolution = 32;
    private double m_user_peak_detection_threshold = 0.05;
    private double m_user_moving_average_width = 25.0;
    private double m_vocaloid_peak_detection_threshold = 0.2;
    private double m_vocaloid_moving_average_width = 25.0;
    private System.Windows.Forms.Label lblReference;
    private System.Windows.Forms.TextBox txtReference;
    private System.Windows.Forms.OpenFileDialog openWaveDialog;
    private System.Windows.Forms.GroupBox groupFormantoWindowWidth;
    private System.Windows.Forms.ComboBox comboFormantoWindowFunctionType;
    private System.Windows.Forms.Label lblFormantoWindowFunctionType;
    private System.Windows.Forms.RadioButton radioFormanto0512;
    private System.Windows.Forms.RadioButton radioFormanto2048;
    private System.Windows.Forms.RadioButton radioFormanto1024;
    private System.Windows.Forms.RadioButton radioFormanto8192;
    private System.Windows.Forms.RadioButton radioFormanto4096;
    private System.Windows.Forms.Button btnExecute;
    private System.Windows.Forms.TabControl tabConfig;
    private System.Windows.Forms.TabPage tabFormanto;
    private System.Windows.Forms.TabPage tabVolume;
    private System.Windows.Forms.Label lblClockResolution;
    private System.Windows.Forms.TextBox txtClockResolution;
    private System.Windows.Forms.Label lblNumIteration;
    private System.Windows.Forms.NumericUpDown numIteration;
    private System.Windows.Forms.Button btnCancel;
    private System.Windows.Forms.GroupBox groupUserWave;
    private System.Windows.Forms.TextBox txtUserPeakDetectionThreshold;
    private System.Windows.Forms.Label lblUserPeakDetectionThreshold;
    private System.Windows.Forms.TextBox txtUserMovingAverageWidth;
    private System.Windows.Forms.Label lblUserMovingAverageWidth;
    private System.Windows.Forms.GroupBox groupVocaloidWave;
    private System.Windows.Forms.TextBox txtVocaloidMovingAverageWidth;
    private System.Windows.Forms.Label lblVocaloidMovingAverageWidth;
    private System.Windows.Forms.TextBox txtVocaloidPeakDetectionThreshold;
    private System.Windows.Forms.Label lblVocaloidPeakDetectionThreshold;
    private System.Windows.Forms.ComboBox comboVolumeWindowFunctionType;
    private System.Windows.Forms.Label lblVolumeWindowFunctionType;
    private System.Windows.Forms.GroupBox groupVolumeWindowWidth;
    private System.Windows.Forms.RadioButton radioVolume8192;
    private System.Windows.Forms.RadioButton radioVolume4096;
    private System.Windows.Forms.RadioButton radioVolume2048;
    private System.Windows.Forms.RadioButton radioVolume1024;
    private System.Windows.Forms.RadioButton radioVolume0512;
    private System.Windows.Forms.Button btnReferenceBrowse;

    public Pitch_and_Volume_Adjuster() {
        InitializeComponent();
        txtClockResolution.Text = m_clock_resolution.ToString();
        txtUserPeakDetectionThreshold.Text = m_user_peak_detection_threshold.ToString();
        txtUserMovingAverageWidth.Text = m_user_moving_average_width.ToString();
        txtVocaloidPeakDetectionThreshold.Text = m_vocaloid_peak_detection_threshold.ToString();
        txtVocaloidMovingAverageWidth.Text = m_vocaloid_moving_average_width.ToString();
        comboFormantoWindowFunctionType.Items.Clear();
        comboVolumeWindowFunctionType.Items.Clear();
        int index = 0;
        int count = -1;
        foreach ( bocoree.math.WindowFunctionType wft in System.Enum.GetValues( typeof( bocoree.math.WindowFunctionType ) ) ) {
            count++;
            comboFormantoWindowFunctionType.Items.Add( wft );
            comboVolumeWindowFunctionType.Items.Add( wft );
            if ( wft == bocoree.math.WindowFunctionType.Hamming ) {
                index = count;
            }
        }
        comboFormantoWindowFunctionType.SelectedIndex = index;
        comboVolumeWindowFunctionType.SelectedIndex = index;
    }

    public static bool Edit( Boare.Lib.Vsq.VsqFile vsq ) {
        string source_wav = "";
        bocoree.math.WindowFunctionType formanto_window_type = bocoree.math.WindowFunctionType.Hamming;
        bocoree.math.WindowFunctionType volume_window_type = bocoree.math.WindowFunctionType.Hamming;
        Boare.Lib.Media.FormantoDetectionArguments user_detection_option = new Boare.Lib.Media.FormantoDetectionArguments();
        Boare.Lib.Media.FormantoDetectionArguments vocaloid_detection_option = new Boare.Lib.Media.FormantoDetectionArguments();
        int formanto_window_width = 2048;
        int volume_window_width = 2048;
        int target_track = 1;
        int clock_resolution = 8;
        int num_iteration = 1;
        using ( Pitch_and_Volume_Adjuster d = new Pitch_and_Volume_Adjuster() ) {
            if ( d.ShowDialog() != System.Windows.Forms.DialogResult.OK ) {
                return false;
            } else {
                source_wav = d.ReferenceWave;
                formanto_window_type = d.FormantoWindowType;
                formanto_window_width = d.FormantoWindowWidth;
                volume_window_type = d.VolumeWindowType;
                volume_window_width = d.VolumeWindowWidth;
                clock_resolution = d.ClockResollution;
                num_iteration = d.IterationNumber;
                user_detection_option = d.UserFormantoDetectionOption;
                vocaloid_detection_option = d.VocaloidFormantoDetectionOption;
            }
        }

        // 先ず音源のフォルマントと音量を解析
        double max_volume_reference = 0.0;
        Boare.Cadencii.BezierChain bez_reference_f0;
        Boare.Cadencii.BezierChain bez_reference_volume;
        using ( Boare.Lib.Media.Wave wave_reference = new Boare.Lib.Media.Wave( source_wav ) ) {
            calculate_f0( wave_reference,
                          formanto_window_type,
                          formanto_window_width,
                          user_detection_option,
                          out bez_reference_f0 );
            calculate_volume( wave_reference,
                              volume_window_type,
                              volume_window_width,
                              out bez_reference_volume );
            for ( int i = 0; i < bez_reference_volume.Count; i++ ) {
                max_volume_reference = System.Math.Max( max_volume_reference, bez_reference_volume[i].Base.Y );
            }
        }
        string path = System.IO.Path.GetDirectoryName( source_wav );
        using ( System.IO.StreamWriter sw = new System.IO.StreamWriter( System.IO.Path.Combine( path, "src_f0.txt" ) ) ) {
            for ( int i = 0; i < bez_reference_f0.Count; i++ ) {
                Boare.Cadencii.BezierPoint b = bez_reference_f0[i];
                sw.WriteLine( b.Base.X + "\t" + b.Base.Y );
            }
        }

        Boare.Cadencii.BezierChain p_f0 = new Boare.Cadencii.BezierChain();       // VSQにセットしたピッチの値
        Boare.Cadencii.BezierChain n_f0 = new Boare.Cadencii.BezierChain();       // 次にVSQにセットするピッチの値
        Boare.Cadencii.BezierChain r_f0 = new Boare.Cadencii.BezierChain();       // VSQをWAVEに出力した結果
        Boare.Cadencii.BezierChain p_volume = new Boare.Cadencii.BezierChain();
        Boare.Cadencii.BezierChain n_volume = new Boare.Cadencii.BezierChain();
        Boare.Cadencii.BezierChain r_volume = new Boare.Cadencii.BezierChain();
        double alpha = 0.2;                     // 加速係数
        for ( int i = 0; i < bez_reference_f0.Count; i++ ) {
            double time = bez_reference_f0[i].Base.X;
            double value = bez_reference_f0[i].Base.Y;
            p_f0.Add( new Boare.Cadencii.BezierPoint( time, value ) );
            r_f0.Add( new Boare.Cadencii.BezierPoint( time, value ) );
        }
        for ( int i = 0; i < bez_reference_volume.Count; i++ ) {
            double time = bez_reference_volume[i].Base.X;
            double value = bez_reference_volume[i].Base.Y;
            p_volume.Add( new Boare.Cadencii.BezierPoint( time, value ) );
            r_volume.Add( new Boare.Cadencii.BezierPoint( time, value ) );
        }

        for ( int itr = 0; itr < num_iteration + 1; itr++ ) {
            int last_pbs = 2;
            string file = System.IO.Path.Combine( path, itr + ".wav" );
            n_f0.Clear();
            n_volume.Clear();
            vsq.Tracks[target_track]["PBS"].Clear();
            vsq.Tracks[target_track]["PIT"].Clear();
            vsq.Tracks[target_track]["PBS"].Add( vsq.PreMeasureClocks, last_pbs );
            vsq.Tracks[target_track]["DYN"].Clear();
            vsq.Tracks[target_track]["DYN"].Add( vsq.PreMeasureClocks, 127 );   // 127を入れておき、実現可能な音量の最大値を調べておく
            using ( System.IO.StreamWriter sw = new System.IO.StreamWriter( System.IO.Path.Combine( path, itr + "_f0_p.txt" ) ) ) {
                for ( int i = 0; i < p_f0.Count; i++ ) {
                    sw.WriteLine( p_f0[i].Base.X + "\t" + p_f0[i].Base.Y );
                }
            }

            // 最後の音符イベントのインデクスを取得
            int last_note_index = 0;
            for ( int i = vsq.Tracks[target_track].Events.Count - 1; i >= 0; i-- ) {
                if ( vsq.Tracks[target_track].Events[i].ID.type == Boare.Lib.Vsq.VsqIDType.Anote ) {
                    last_note_index = i;
                    break;
                }
            }
            System.Collections.Generic.SortedList<int, System.Collections.Generic.KeyValuePair<int, double>> list = 
                new System.Collections.Generic.SortedList<int, System.Collections.Generic.KeyValuePair<int, double>>();
            for ( int i = 0; i <= last_note_index; i++ ) {
                Boare.Lib.Vsq.VsqEvent ve = vsq.Tracks[target_track].Events[i];
                if ( ve.ID.type == Boare.Lib.Vsq.VsqIDType.Anote ) {
                    int note = ve.ID.Note;
                    double fbase = 440.0 * System.Math.Pow( 2.0, (note - 69) / 12.0 );
                    int end_clock = ve.Clock + ve.ID.Length;
                    if ( i < last_note_index ) {
                        end_clock = System.Math.Max( end_clock, vsq.Tracks[target_track].Events[i + 1].Clock );
                    }
                    for ( int clock = ve.Clock; clock < end_clock; clock += clock_resolution ) {
                        double time = vsq.SecFromClock( clock );
                        double vol_coeff = r_volume.GetValue( time ) / max_volume_reference; //音量の小さいところでは補正幅を小さくする。
                        int new_value = (int)(p_f0.GetValue( time ) + alpha * (bez_reference_f0.GetValue( time ) - r_f0.GetValue( time )) * vol_coeff);
                        list.Add( clock, new System.Collections.Generic.KeyValuePair<int, double>( new_value, fbase ) );
                    }
                }
            }
            // 移動平均を取る
            for ( int i = 0; i < list.Count; i++ ) {

            }
            // n_f0に転写
            for ( int i = 0; i < list.Count; i++ ) {
                int clock = list.Keys[i];
                int value = list[clock].Key;
                double time = vsq.SecFromClock( clock );
                n_f0.Add( new Boare.Cadencii.BezierPoint( time, value ) );
            }
            // 適用
            for ( int i = 0; i < list.Count; i++ ) {
                int clock = list.Keys[i];
                int value = list[clock].Key;
                double fbase = list[clock].Value;
                int pbs, pit;
                get_pit_and_pbs( value, fbase, out pbs, out pit );
                vsq.Tracks[target_track]["PIT"].Add( clock, pit );
                if ( last_pbs != pbs ) {
                    vsq.Tracks[target_track]["PBS"].Add( clock, pbs );
                    last_pbs = pbs;
                }
            }
            using ( System.IO.StreamWriter sw = new System.IO.StreamWriter( System.IO.Path.Combine( path, itr + "_f0_n.txt" ) ) ) {
                for ( int i = 0; i < n_f0.Count; i++ ) {
                    sw.WriteLine( n_f0[i].Base.X + "\t" + n_f0[i].Base.Y );
                }
            }

            p_f0.Clear();
            for ( int i = 0; i < n_f0.Count; i++ ) {
                p_f0.Add( n_f0[i] );
            }
            p_volume.Clear();
            for ( int i = 0; i < n_volume.Count; i++ ) {
                p_volume.Add( n_volume[i] );
            }
            r_f0.Clear();
            r_volume.Clear();
            int count = vsq.Tracks[target_track].Events.Count;
            if ( count > 0 ) {
                Boare.Cadencii.VSTiProxy.Render( vsq,
                                                 target_track,
                                                 file,
                                                 0.0,
                                                 vsq.SecFromClock( vsq.TotalClocks ),
                                                 1.0,
                                                 1.0,
                                                 500,
                                                 false,
                                                 new string[] { },
                                                 0.0 );
            }

            double max_volume_rendered = 0.0;
            using ( Boare.Lib.Media.Wave wv = new Boare.Lib.Media.Wave( file ) ) {
                calculate_f0( wv,
                              formanto_window_type,
                              formanto_window_width,
                              vocaloid_detection_option,
                              out r_f0 );
                calculate_volume( wv,
                                  volume_window_type,
                                  volume_window_width,
                                  out r_volume );
                for ( int i = 0; i < r_volume.Count; i++ ) {
                    max_volume_rendered = System.Math.Max( max_volume_rendered, r_volume[i].Base.X );
                }
            }

            // 音量に応じてDYNを調整
            double amplify = max_volume_rendered / max_volume_reference;
            for ( int clock = vsq.PreMeasureClocks; clock < vsq.TotalClocks; clock += clock_resolution ) {
                double time = vsq.SecFromClock( (int)clock );
                int dyn = (int)(r_volume.GetValue( time ) * amplify / max_volume_rendered * 127.0);
                vsq.Tracks[target_track]["DYN"].Add( (int)clock, dyn );
            }

            using ( System.IO.StreamWriter sw = new System.IO.StreamWriter( System.IO.Path.Combine( path, itr + "_f0_r.txt" ) ) ) {
                for ( int i = 0; i < r_f0.Count; i++ ) {
                    sw.WriteLine( r_f0[i].Base.X + "\t" + r_f0[i].Base.Y );
                }
            }
        }
        return true;
    }

    private static void calculate_f0( Boare.Lib.Media.Wave wv,
                                      bocoree.math.WindowFunctionType formanto_window_type,
                                      int formanto_window_width,
                                      Boare.Lib.Media.FormantoDetectionArguments option,
                                      out Boare.Cadencii.BezierChain f0 ){
        uint sample_rate = wv.SampleRate;
        const double sec_dt = 0.0025;
        uint samples = wv.TotalSamples;
        uint spl_dt = (uint)(sec_dt * sample_rate);
        double[] window_func = new double[formanto_window_width];
        for ( int i = 0; i < formanto_window_width; i++ ) {
            window_func[i] = bocoree.math.window_func( formanto_window_type, i / (double)formanto_window_width );
        }
        int num_data = (int)(samples / spl_dt);

        double[] buf = new double[num_data];
        for ( int i = 0; i < num_data; i++ ) {
            int spl_i = (int)(spl_dt * i);
            buf[i] = wv.GetF0( (uint)spl_i, window_func, option );
        }
        for ( int i = 1; i < num_data - 1; i++ ) {
            double d = (buf[i] - buf[i - 1]) * (buf[i + 1] - buf[i]);
            if ( d < 0.0 ) {
                buf[i] = (buf[i - 1] + buf[i - 1]) * 0.5;
            }
        }
        f0 = new Boare.Cadencii.BezierChain();
        for ( int i = 0; i < num_data; i++ ) {
            double time = (spl_dt * i) / (double)sample_rate;
            Boare.Cadencii.BezierPoint bp = new Boare.Cadencii.BezierPoint( new Boare.Cadencii.PointD( time, buf[i] ) );
            bp.ControlLeftType = Boare.Cadencii.BezierControlType.None;
            bp.ControlRightType = Boare.Cadencii.BezierControlType.None;
            f0.Add( bp );
        }
    }

    private static void calculate_volume( Boare.Lib.Media.Wave wv,
                                          bocoree.math.WindowFunctionType volulme_window_type,
                                          int volume_window_width,
                                          out Boare.Cadencii.BezierChain volume ) {
        uint sample_rate = wv.SampleRate;
        const double sec_dt = 0.0025;
        uint samples = wv.TotalSamples;
        uint spl_dt = (uint)(sec_dt * sample_rate);
        double[] window_func = new double[volume_window_width];
        for ( int i = 0; i < volume_window_width; i++ ) {
            window_func[i] = bocoree.math.window_func( volulme_window_type, i / (double)volume_window_width );
        }
        int num_data = (int)(samples / spl_dt);

        volume = new Boare.Cadencii.BezierChain();
        for ( int i = 0; i < num_data; i++ ) {
            int spl_i = (int)(i * spl_dt);
            double v = wv.GetVolume( spl_i, window_func );
            Boare.Cadencii.BezierPoint bp = new Boare.Cadencii.BezierPoint( new Boare.Cadencii.PointD( spl_i / (double)sample_rate, v ) );
            bp.ControlLeftType = Boare.Cadencii.BezierControlType.None;
            bp.ControlRightType = Boare.Cadencii.BezierControlType.None;
            volume.Add( bp );
        }
    }

    /// <summary>
    /// 第一フォルマントの周波数と、元音符の周波数を元に、指定するべきPBSとPITの値を計算します
    /// </summary>
    /// <param name="freq"></param>
    /// <param name="fbase"></param>
    /// <param name="pbs"></param>
    /// <param name="pit"></param>
    private static void get_pit_and_pbs( double freq, double fbase, out int pbs, out int pit ) {
        pit = 0;
        for ( pbs = 1; pbs <= 24; pbs++ ) {
            pit = (int)pit_from_pbs( freq, pbs, fbase );
            if ( -8192 <= pit && pit <= 8191 ) {
                return;
            }
        }
        pbs = 24;
        if ( pit < -8192 ) {
            pit = -8192;
        } else if ( 8191 < pit ) {
            pit = 8191;
        }
    }

    private static double pit_from_pbs( double freq, int pbs, double fbase ) {
        return 98304.0 / (double)pbs * System.Math.Log( freq / fbase, 2.0 );
    }

    public Boare.Lib.Media.FormantoDetectionArguments UserFormantoDetectionOption {
        get {
            Boare.Lib.Media.FormantoDetectionArguments ret = new Boare.Lib.Media.FormantoDetectionArguments();
            ret.PeakDetectionThreshold = m_user_peak_detection_threshold;
            ret.MovingAverageWidth = m_user_moving_average_width;
            return ret;
        }
    }

    public Boare.Lib.Media.FormantoDetectionArguments VocaloidFormantoDetectionOption {
        get {
            Boare.Lib.Media.FormantoDetectionArguments ret = new Boare.Lib.Media.FormantoDetectionArguments();
            ret.PeakDetectionThreshold = m_vocaloid_peak_detection_threshold;
            ret.MovingAverageWidth = m_vocaloid_moving_average_width;
            return ret;
        }
    }

    public int IterationNumber {
        get {
            return (int)numIteration.Value;
        }
        set {
            numIteration.Value = value;
        }
    }

    public int ClockResollution {
        get {
            return m_clock_resolution;
        }
        set {
            m_clock_resolution = value;
            if ( m_clock_resolution <= 0 ) {
                m_clock_resolution = 1;
            }
            txtClockResolution.Text = m_clock_resolution.ToString();
        }
    }

    public int FormantoWindowWidth {
        get {
            if ( radioFormanto0512.Checked ) {
                return 512;
            } else if ( radioFormanto1024.Checked ) {
                return 1024;
            } else if ( radioFormanto2048.Checked ) {
                return 2048;
            } else if ( radioFormanto4096.Checked ) {
                return 4096;
            } else if ( radioFormanto8192.Checked ) {
                return 8192;
            } else {
                return 2048;
            }
        }
    }

    public bocoree.math.WindowFunctionType FormantoWindowType {
        get {
            return (bocoree.math.WindowFunctionType)comboFormantoWindowFunctionType.SelectedItem;
        }
    }

    public int VolumeWindowWidth {
        get {
            if ( radioVolume0512.Checked ) {
                return 512;
            } else if ( radioVolume1024.Checked ) {
                return 1024;
            } else if ( radioVolume2048.Checked ) {
                return 2048;
            } else if ( radioVolume4096.Checked ) {
                return 4096;
            } else if ( radioVolume8192.Checked ) {
                return 8192;
            } else {
                return 2048;
            }
        }
    }

    public bocoree.math.WindowFunctionType VolumeWindowType {
        get{
            return (bocoree.math.WindowFunctionType)comboVolumeWindowFunctionType.SelectedItem;
        }
    }

    /// <summary>
    /// リファレンスとして使用するWAVEファイル
    /// </summary>
    public string ReferenceWave {
        get {
            return txtReference.Text;
        }
        set {
            txtReference.Text = value;
        }
    }

    /// <summary>
    /// 必要なデザイナ変数です。
    /// </summary>
    private System.ComponentModel.IContainer components = null;

    /// <summary>
    /// 使用中のリソースをすべてクリーンアップします。
    /// </summary>
    /// <param name="disposing">マネージ リソースが破棄される場合 true、破棄されない場合は false です。</param>
    protected override void Dispose( bool disposing ) {
        if ( disposing && (components != null) ) {
            components.Dispose();
        }
        base.Dispose( disposing );
    }

    #region Windows フォーム デザイナで生成されたコード
    /// <summary>
    /// デザイナ サポートに必要なメソッドです。このメソッドの内容を
    /// コード エディタで変更しないでください。
    /// </summary>
    private void InitializeComponent() {
        this.lblReference = new System.Windows.Forms.Label();
        this.txtReference = new System.Windows.Forms.TextBox();
        this.btnReferenceBrowse = new System.Windows.Forms.Button();
        this.openWaveDialog = new System.Windows.Forms.OpenFileDialog();
        this.groupFormantoWindowWidth = new System.Windows.Forms.GroupBox();
        this.radioFormanto8192 = new System.Windows.Forms.RadioButton();
        this.radioFormanto4096 = new System.Windows.Forms.RadioButton();
        this.radioFormanto2048 = new System.Windows.Forms.RadioButton();
        this.radioFormanto1024 = new System.Windows.Forms.RadioButton();
        this.radioFormanto0512 = new System.Windows.Forms.RadioButton();
        this.lblFormantoWindowFunctionType = new System.Windows.Forms.Label();
        this.comboFormantoWindowFunctionType = new System.Windows.Forms.ComboBox();
        this.btnExecute = new System.Windows.Forms.Button();
        this.tabConfig = new System.Windows.Forms.TabControl();
        this.tabFormanto = new System.Windows.Forms.TabPage();
        this.groupVocaloidWave = new System.Windows.Forms.GroupBox();
        this.txtVocaloidMovingAverageWidth = new System.Windows.Forms.TextBox();
        this.lblVocaloidMovingAverageWidth = new System.Windows.Forms.Label();
        this.txtVocaloidPeakDetectionThreshold = new System.Windows.Forms.TextBox();
        this.lblVocaloidPeakDetectionThreshold = new System.Windows.Forms.Label();
        this.groupUserWave = new System.Windows.Forms.GroupBox();
        this.txtUserMovingAverageWidth = new System.Windows.Forms.TextBox();
        this.lblUserMovingAverageWidth = new System.Windows.Forms.Label();
        this.txtUserPeakDetectionThreshold = new System.Windows.Forms.TextBox();
        this.lblUserPeakDetectionThreshold = new System.Windows.Forms.Label();
        this.tabVolume = new System.Windows.Forms.TabPage();
        this.lblClockResolution = new System.Windows.Forms.Label();
        this.txtClockResolution = new System.Windows.Forms.TextBox();
        this.lblNumIteration = new System.Windows.Forms.Label();
        this.numIteration = new System.Windows.Forms.NumericUpDown();
        this.btnCancel = new System.Windows.Forms.Button();
        this.comboVolumeWindowFunctionType = new System.Windows.Forms.ComboBox();
        this.lblVolumeWindowFunctionType = new System.Windows.Forms.Label();
        this.groupVolumeWindowWidth = new System.Windows.Forms.GroupBox();
        this.radioVolume8192 = new System.Windows.Forms.RadioButton();
        this.radioVolume4096 = new System.Windows.Forms.RadioButton();
        this.radioVolume2048 = new System.Windows.Forms.RadioButton();
        this.radioVolume1024 = new System.Windows.Forms.RadioButton();
        this.radioVolume0512 = new System.Windows.Forms.RadioButton();
        this.groupFormantoWindowWidth.SuspendLayout();
        this.tabConfig.SuspendLayout();
        this.tabFormanto.SuspendLayout();
        this.groupVocaloidWave.SuspendLayout();
        this.groupUserWave.SuspendLayout();
        this.tabVolume.SuspendLayout();
        ((System.ComponentModel.ISupportInitialize)(this.numIteration)).BeginInit();
        this.groupVolumeWindowWidth.SuspendLayout();
        this.SuspendLayout();
        // 
        // lblReference
        // 
        this.lblReference.AutoSize = true;
        this.lblReference.Location = new System.Drawing.Point( 12, 19 );
        this.lblReference.Name = "lblReference";
        this.lblReference.Size = new System.Drawing.Size( 113, 12 );
        this.lblReference.TabIndex = 0;
        this.lblReference.Text = "Reference WAVE file";
        // 
        // txtReference
        // 
        this.txtReference.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right)));
        this.txtReference.Location = new System.Drawing.Point( 131, 16 );
        this.txtReference.Name = "txtReference";
        this.txtReference.ReadOnly = true;
        this.txtReference.Size = new System.Drawing.Size( 139, 19 );
        this.txtReference.TabIndex = 1;
        // 
        // btnReferenceBrowse
        // 
        this.btnReferenceBrowse.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
        this.btnReferenceBrowse.Location = new System.Drawing.Point( 276, 14 );
        this.btnReferenceBrowse.Name = "btnReferenceBrowse";
        this.btnReferenceBrowse.Size = new System.Drawing.Size( 75, 23 );
        this.btnReferenceBrowse.TabIndex = 2;
        this.btnReferenceBrowse.Text = "browse";
        this.btnReferenceBrowse.UseVisualStyleBackColor = true;
        this.btnReferenceBrowse.Click += new System.EventHandler( this.btnReferenceBrowse_Click );
        // 
        // groupFormantoWindowWidth
        // 
        this.groupFormantoWindowWidth.Controls.Add( this.radioFormanto8192 );
        this.groupFormantoWindowWidth.Controls.Add( this.radioFormanto4096 );
        this.groupFormantoWindowWidth.Controls.Add( this.radioFormanto2048 );
        this.groupFormantoWindowWidth.Controls.Add( this.radioFormanto1024 );
        this.groupFormantoWindowWidth.Controls.Add( this.radioFormanto0512 );
        this.groupFormantoWindowWidth.Location = new System.Drawing.Point( 11, 65 );
        this.groupFormantoWindowWidth.Name = "groupFormantoWindowWidth";
        this.groupFormantoWindowWidth.Size = new System.Drawing.Size( 316, 49 );
        this.groupFormantoWindowWidth.TabIndex = 3;
        this.groupFormantoWindowWidth.TabStop = false;
        this.groupFormantoWindowWidth.Text = "Window Width";
        // 
        // radioFormanto8192
        // 
        this.radioFormanto8192.AutoSize = true;
        this.radioFormanto8192.Location = new System.Drawing.Point( 223, 18 );
        this.radioFormanto8192.Name = "radioFormanto8192";
        this.radioFormanto8192.Size = new System.Drawing.Size( 47, 16 );
        this.radioFormanto8192.TabIndex = 8;
        this.radioFormanto8192.TabStop = true;
        this.radioFormanto8192.Text = "8192";
        this.radioFormanto8192.UseVisualStyleBackColor = true;
        // 
        // radioFormanto4096
        // 
        this.radioFormanto4096.AutoSize = true;
        this.radioFormanto4096.Location = new System.Drawing.Point( 170, 18 );
        this.radioFormanto4096.Name = "radioFormanto4096";
        this.radioFormanto4096.Size = new System.Drawing.Size( 47, 16 );
        this.radioFormanto4096.TabIndex = 7;
        this.radioFormanto4096.TabStop = true;
        this.radioFormanto4096.Text = "4096";
        this.radioFormanto4096.UseVisualStyleBackColor = true;
        // 
        // radioFormanto2048
        // 
        this.radioFormanto2048.AutoSize = true;
        this.radioFormanto2048.Checked = true;
        this.radioFormanto2048.Location = new System.Drawing.Point( 117, 18 );
        this.radioFormanto2048.Name = "radioFormanto2048";
        this.radioFormanto2048.Size = new System.Drawing.Size( 47, 16 );
        this.radioFormanto2048.TabIndex = 6;
        this.radioFormanto2048.TabStop = true;
        this.radioFormanto2048.Text = "2048";
        this.radioFormanto2048.UseVisualStyleBackColor = true;
        // 
        // radioFormanto1024
        // 
        this.radioFormanto1024.AutoSize = true;
        this.radioFormanto1024.Location = new System.Drawing.Point( 61, 18 );
        this.radioFormanto1024.Name = "radioFormanto1024";
        this.radioFormanto1024.Size = new System.Drawing.Size( 47, 16 );
        this.radioFormanto1024.TabIndex = 5;
        this.radioFormanto1024.Text = "1024";
        this.radioFormanto1024.UseVisualStyleBackColor = true;
        // 
        // radioFormanto0512
        // 
        this.radioFormanto0512.AutoSize = true;
        this.radioFormanto0512.Location = new System.Drawing.Point( 14, 18 );
        this.radioFormanto0512.Name = "radioFormanto0512";
        this.radioFormanto0512.Size = new System.Drawing.Size( 41, 16 );
        this.radioFormanto0512.TabIndex = 2;
        this.radioFormanto0512.Text = "512";
        this.radioFormanto0512.UseVisualStyleBackColor = true;
        // 
        // lblFormantoWindowFunctionType
        // 
        this.lblFormantoWindowFunctionType.AutoSize = true;
        this.lblFormantoWindowFunctionType.Location = new System.Drawing.Point( 18, 16 );
        this.lblFormantoWindowFunctionType.Name = "lblFormantoWindowFunctionType";
        this.lblFormantoWindowFunctionType.Size = new System.Drawing.Size( 120, 12 );
        this.lblFormantoWindowFunctionType.TabIndex = 1;
        this.lblFormantoWindowFunctionType.Text = "Window Function Type";
        // 
        // comboFormantoWindowFunctionType
        // 
        this.comboFormantoWindowFunctionType.FormattingEnabled = true;
        this.comboFormantoWindowFunctionType.Location = new System.Drawing.Point( 39, 34 );
        this.comboFormantoWindowFunctionType.Name = "comboFormantoWindowFunctionType";
        this.comboFormantoWindowFunctionType.Size = new System.Drawing.Size( 121, 20 );
        this.comboFormantoWindowFunctionType.TabIndex = 0;
        // 
        // btnExecute
        // 
        this.btnExecute.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
        this.btnExecute.Enabled = false;
        this.btnExecute.Location = new System.Drawing.Point( 204, 457 );
        this.btnExecute.Name = "btnExecute";
        this.btnExecute.Size = new System.Drawing.Size( 75, 23 );
        this.btnExecute.TabIndex = 4;
        this.btnExecute.Text = "Execute";
        this.btnExecute.UseVisualStyleBackColor = true;
        this.btnExecute.Click += new System.EventHandler( this.btnExecute_Click );
        // 
        // tabConfig
        // 
        this.tabConfig.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left)
                    | System.Windows.Forms.AnchorStyles.Right)));
        this.tabConfig.Controls.Add( this.tabFormanto );
        this.tabConfig.Controls.Add( this.tabVolume );
        this.tabConfig.Location = new System.Drawing.Point( 12, 101 );
        this.tabConfig.Name = "tabConfig";
        this.tabConfig.SelectedIndex = 0;
        this.tabConfig.Size = new System.Drawing.Size( 348, 340 );
        this.tabConfig.TabIndex = 5;
        // 
        // tabFormanto
        // 
        this.tabFormanto.Controls.Add( this.groupVocaloidWave );
        this.tabFormanto.Controls.Add( this.groupUserWave );
        this.tabFormanto.Controls.Add( this.comboFormantoWindowFunctionType );
        this.tabFormanto.Controls.Add( this.lblFormantoWindowFunctionType );
        this.tabFormanto.Controls.Add( this.groupFormantoWindowWidth );
        this.tabFormanto.Location = new System.Drawing.Point( 4, 21 );
        this.tabFormanto.Name = "tabFormanto";
        this.tabFormanto.Padding = new System.Windows.Forms.Padding( 3 );
        this.tabFormanto.Size = new System.Drawing.Size( 340, 315 );
        this.tabFormanto.TabIndex = 0;
        this.tabFormanto.Text = "Formanto";
        this.tabFormanto.UseVisualStyleBackColor = true;
        // 
        // groupVocaloidWave
        // 
        this.groupVocaloidWave.Controls.Add( this.txtVocaloidMovingAverageWidth );
        this.groupVocaloidWave.Controls.Add( this.lblVocaloidMovingAverageWidth );
        this.groupVocaloidWave.Controls.Add( this.txtVocaloidPeakDetectionThreshold );
        this.groupVocaloidWave.Controls.Add( this.lblVocaloidPeakDetectionThreshold );
        this.groupVocaloidWave.Location = new System.Drawing.Point( 11, 214 );
        this.groupVocaloidWave.Name = "groupVocaloidWave";
        this.groupVocaloidWave.Size = new System.Drawing.Size( 316, 88 );
        this.groupVocaloidWave.TabIndex = 5;
        this.groupVocaloidWave.TabStop = false;
        this.groupVocaloidWave.Text = "Detection Option (VOCALOID WAVE)";
        // 
        // txtVocaloidMovingAverageWidth
        // 
        this.txtVocaloidMovingAverageWidth.Location = new System.Drawing.Point( 186, 49 );
        this.txtVocaloidMovingAverageWidth.Name = "txtVocaloidMovingAverageWidth";
        this.txtVocaloidMovingAverageWidth.Size = new System.Drawing.Size( 100, 19 );
        this.txtVocaloidMovingAverageWidth.TabIndex = 3;
        this.txtVocaloidMovingAverageWidth.Text = "25";
        this.txtVocaloidMovingAverageWidth.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
        this.txtVocaloidMovingAverageWidth.TextChanged += new System.EventHandler( this.txtVocaloidMovingAverageWidth_TextChanged );
        // 
        // lblVocaloidMovingAverageWidth
        // 
        this.lblVocaloidMovingAverageWidth.AutoSize = true;
        this.lblVocaloidMovingAverageWidth.Location = new System.Drawing.Point( 20, 52 );
        this.lblVocaloidMovingAverageWidth.Name = "lblVocaloidMovingAverageWidth";
        this.lblVocaloidMovingAverageWidth.Size = new System.Drawing.Size( 144, 12 );
        this.lblVocaloidMovingAverageWidth.TabIndex = 2;
        this.lblVocaloidMovingAverageWidth.Text = "Moving Average Width (Hz)";
        // 
        // txtVocaloidPeakDetectionThreshold
        // 
        this.txtVocaloidPeakDetectionThreshold.Location = new System.Drawing.Point( 186, 24 );
        this.txtVocaloidPeakDetectionThreshold.Name = "txtVocaloidPeakDetectionThreshold";
        this.txtVocaloidPeakDetectionThreshold.Size = new System.Drawing.Size( 100, 19 );
        this.txtVocaloidPeakDetectionThreshold.TabIndex = 1;
        this.txtVocaloidPeakDetectionThreshold.Text = "0.1";
        this.txtVocaloidPeakDetectionThreshold.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
        this.txtVocaloidPeakDetectionThreshold.TextChanged += new System.EventHandler( this.txtVocaloidPeakDetectionThreshold_TextChanged );
        // 
        // lblVocaloidPeakDetectionThreshold
        // 
        this.lblVocaloidPeakDetectionThreshold.AutoSize = true;
        this.lblVocaloidPeakDetectionThreshold.Location = new System.Drawing.Point( 20, 27 );
        this.lblVocaloidPeakDetectionThreshold.Name = "lblVocaloidPeakDetectionThreshold";
        this.lblVocaloidPeakDetectionThreshold.Size = new System.Drawing.Size( 137, 12 );
        this.lblVocaloidPeakDetectionThreshold.TabIndex = 0;
        this.lblVocaloidPeakDetectionThreshold.Text = "Peak Detection Threshold";
        // 
        // groupUserWave
        // 
        this.groupUserWave.Controls.Add( this.txtUserMovingAverageWidth );
        this.groupUserWave.Controls.Add( this.lblUserMovingAverageWidth );
        this.groupUserWave.Controls.Add( this.txtUserPeakDetectionThreshold );
        this.groupUserWave.Controls.Add( this.lblUserPeakDetectionThreshold );
        this.groupUserWave.Location = new System.Drawing.Point( 11, 120 );
        this.groupUserWave.Name = "groupUserWave";
        this.groupUserWave.Size = new System.Drawing.Size( 316, 88 );
        this.groupUserWave.TabIndex = 4;
        this.groupUserWave.TabStop = false;
        this.groupUserWave.Text = "Detection Option (User WAVE)";
        // 
        // txtUserMovingAverageWidth
        // 
        this.txtUserMovingAverageWidth.Location = new System.Drawing.Point( 186, 49 );
        this.txtUserMovingAverageWidth.Name = "txtUserMovingAverageWidth";
        this.txtUserMovingAverageWidth.Size = new System.Drawing.Size( 100, 19 );
        this.txtUserMovingAverageWidth.TabIndex = 3;
        this.txtUserMovingAverageWidth.Text = "25";
        this.txtUserMovingAverageWidth.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
        this.txtUserMovingAverageWidth.TextChanged += new System.EventHandler( this.txtUserMovingAverageWidth_TextChanged );
        // 
        // lblUserMovingAverageWidth
        // 
        this.lblUserMovingAverageWidth.AutoSize = true;
        this.lblUserMovingAverageWidth.Location = new System.Drawing.Point( 20, 52 );
        this.lblUserMovingAverageWidth.Name = "lblUserMovingAverageWidth";
        this.lblUserMovingAverageWidth.Size = new System.Drawing.Size( 144, 12 );
        this.lblUserMovingAverageWidth.TabIndex = 2;
        this.lblUserMovingAverageWidth.Text = "Moving Average Width (Hz)";
        // 
        // txtUserPeakDetectionThreshold
        // 
        this.txtUserPeakDetectionThreshold.Location = new System.Drawing.Point( 186, 24 );
        this.txtUserPeakDetectionThreshold.Name = "txtUserPeakDetectionThreshold";
        this.txtUserPeakDetectionThreshold.Size = new System.Drawing.Size( 100, 19 );
        this.txtUserPeakDetectionThreshold.TabIndex = 1;
        this.txtUserPeakDetectionThreshold.Text = "0.2";
        this.txtUserPeakDetectionThreshold.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
        this.txtUserPeakDetectionThreshold.TextChanged += new System.EventHandler( this.txtUserPeakDetectionThreshold_TextChanged );
        // 
        // lblUserPeakDetectionThreshold
        // 
        this.lblUserPeakDetectionThreshold.AutoSize = true;
        this.lblUserPeakDetectionThreshold.Location = new System.Drawing.Point( 20, 27 );
        this.lblUserPeakDetectionThreshold.Name = "lblUserPeakDetectionThreshold";
        this.lblUserPeakDetectionThreshold.Size = new System.Drawing.Size( 137, 12 );
        this.lblUserPeakDetectionThreshold.TabIndex = 0;
        this.lblUserPeakDetectionThreshold.Text = "Peak Detection Threshold";
        // 
        // tabVolume
        // 
        this.tabVolume.Controls.Add( this.comboVolumeWindowFunctionType );
        this.tabVolume.Controls.Add( this.lblVolumeWindowFunctionType );
        this.tabVolume.Controls.Add( this.groupVolumeWindowWidth );
        this.tabVolume.Location = new System.Drawing.Point( 4, 21 );
        this.tabVolume.Name = "tabVolume";
        this.tabVolume.Padding = new System.Windows.Forms.Padding( 3 );
        this.tabVolume.Size = new System.Drawing.Size( 340, 315 );
        this.tabVolume.TabIndex = 1;
        this.tabVolume.Text = "Volume";
        this.tabVolume.UseVisualStyleBackColor = true;
        // 
        // lblClockResolution
        // 
        this.lblClockResolution.AutoSize = true;
        this.lblClockResolution.Location = new System.Drawing.Point( 12, 48 );
        this.lblClockResolution.Name = "lblClockResolution";
        this.lblClockResolution.Size = new System.Drawing.Size( 92, 12 );
        this.lblClockResolution.TabIndex = 6;
        this.lblClockResolution.Text = "Clock Resolution";
        // 
        // txtClockResolution
        // 
        this.txtClockResolution.Location = new System.Drawing.Point( 110, 45 );
        this.txtClockResolution.Name = "txtClockResolution";
        this.txtClockResolution.Size = new System.Drawing.Size( 77, 19 );
        this.txtClockResolution.TabIndex = 7;
        this.txtClockResolution.Text = "32";
        this.txtClockResolution.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
        this.txtClockResolution.TextChanged += new System.EventHandler( this.txtClockResolution_TextChanged );
        // 
        // lblNumIteration
        // 
        this.lblNumIteration.AutoSize = true;
        this.lblNumIteration.Location = new System.Drawing.Point( 12, 78 );
        this.lblNumIteration.Name = "lblNumIteration";
        this.lblNumIteration.Size = new System.Drawing.Size( 104, 12 );
        this.lblNumIteration.TabIndex = 8;
        this.lblNumIteration.Text = "Number of Iteration";
        // 
        // numIteration
        // 
        this.numIteration.Location = new System.Drawing.Point( 122, 76 );
        this.numIteration.Minimum = new decimal( new int[] {
            1,
            0,
            0,
            0} );
        this.numIteration.Name = "numIteration";
        this.numIteration.Size = new System.Drawing.Size( 77, 19 );
        this.numIteration.TabIndex = 9;
        this.numIteration.TextAlign = System.Windows.Forms.HorizontalAlignment.Right;
        this.numIteration.Value = new decimal( new int[] {
            1,
            0,
            0,
            0} );
        // 
        // btnCancel
        // 
        this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
        this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
        this.btnCancel.Location = new System.Drawing.Point( 285, 457 );
        this.btnCancel.Name = "btnCancel";
        this.btnCancel.Size = new System.Drawing.Size( 75, 23 );
        this.btnCancel.TabIndex = 10;
        this.btnCancel.Text = "Cancel";
        this.btnCancel.UseVisualStyleBackColor = true;
        // 
        // comboVolumeWindowFunctionType
        // 
        this.comboVolumeWindowFunctionType.FormattingEnabled = true;
        this.comboVolumeWindowFunctionType.Location = new System.Drawing.Point( 39, 34 );
        this.comboVolumeWindowFunctionType.Name = "comboVolumeWindowFunctionType";
        this.comboVolumeWindowFunctionType.Size = new System.Drawing.Size( 121, 20 );
        this.comboVolumeWindowFunctionType.TabIndex = 4;
        // 
        // lblVolumeWindowFunctionType
        // 
        this.lblVolumeWindowFunctionType.AutoSize = true;
        this.lblVolumeWindowFunctionType.Location = new System.Drawing.Point( 18, 16 );
        this.lblVolumeWindowFunctionType.Name = "lblVolumeWindowFunctionType";
        this.lblVolumeWindowFunctionType.Size = new System.Drawing.Size( 120, 12 );
        this.lblVolumeWindowFunctionType.TabIndex = 5;
        this.lblVolumeWindowFunctionType.Text = "Window Function Type";
        // 
        // groupVolumeWindowWidth
        // 
        this.groupVolumeWindowWidth.Controls.Add( this.radioVolume8192 );
        this.groupVolumeWindowWidth.Controls.Add( this.radioVolume4096 );
        this.groupVolumeWindowWidth.Controls.Add( this.radioVolume2048 );
        this.groupVolumeWindowWidth.Controls.Add( this.radioVolume1024 );
        this.groupVolumeWindowWidth.Controls.Add( this.radioVolume0512 );
        this.groupVolumeWindowWidth.Location = new System.Drawing.Point( 11, 65 );
        this.groupVolumeWindowWidth.Name = "groupVolumeWindowWidth";
        this.groupVolumeWindowWidth.Size = new System.Drawing.Size( 316, 49 );
        this.groupVolumeWindowWidth.TabIndex = 6;
        this.groupVolumeWindowWidth.TabStop = false;
        this.groupVolumeWindowWidth.Text = "Window Width";
        // 
        // radioVolume8192
        // 
        this.radioVolume8192.AutoSize = true;
        this.radioVolume8192.Location = new System.Drawing.Point( 223, 18 );
        this.radioVolume8192.Name = "radioVolume8192";
        this.radioVolume8192.Size = new System.Drawing.Size( 47, 16 );
        this.radioVolume8192.TabIndex = 8;
        this.radioVolume8192.TabStop = true;
        this.radioVolume8192.Text = "8192";
        this.radioVolume8192.UseVisualStyleBackColor = true;
        // 
        // radioVolume4096
        // 
        this.radioVolume4096.AutoSize = true;
        this.radioVolume4096.Location = new System.Drawing.Point( 170, 18 );
        this.radioVolume4096.Name = "radioVolume4096";
        this.radioVolume4096.Size = new System.Drawing.Size( 47, 16 );
        this.radioVolume4096.TabIndex = 7;
        this.radioVolume4096.TabStop = true;
        this.radioVolume4096.Text = "4096";
        this.radioVolume4096.UseVisualStyleBackColor = true;
        // 
        // radioVolume2048
        // 
        this.radioVolume2048.AutoSize = true;
        this.radioVolume2048.Checked = true;
        this.radioVolume2048.Location = new System.Drawing.Point( 117, 18 );
        this.radioVolume2048.Name = "radioVolume2048";
        this.radioVolume2048.Size = new System.Drawing.Size( 47, 16 );
        this.radioVolume2048.TabIndex = 6;
        this.radioVolume2048.TabStop = true;
        this.radioVolume2048.Text = "2048";
        this.radioVolume2048.UseVisualStyleBackColor = true;
        // 
        // radioVolume1024
        // 
        this.radioVolume1024.AutoSize = true;
        this.radioVolume1024.Location = new System.Drawing.Point( 61, 18 );
        this.radioVolume1024.Name = "radioVolume1024";
        this.radioVolume1024.Size = new System.Drawing.Size( 47, 16 );
        this.radioVolume1024.TabIndex = 5;
        this.radioVolume1024.Text = "1024";
        this.radioVolume1024.UseVisualStyleBackColor = true;
        // 
        // radioVolume0512
        // 
        this.radioVolume0512.AutoSize = true;
        this.radioVolume0512.Location = new System.Drawing.Point( 14, 18 );
        this.radioVolume0512.Name = "radioVolume0512";
        this.radioVolume0512.Size = new System.Drawing.Size( 41, 16 );
        this.radioVolume0512.TabIndex = 2;
        this.radioVolume0512.Text = "512";
        this.radioVolume0512.UseVisualStyleBackColor = true;
        // 
        // Pitch_and_Volume_Adjuster
        // 
        this.AcceptButton = this.btnExecute;
        this.AutoScaleDimensions = new System.Drawing.SizeF( 6F, 12F );
        this.AutoScaleMode = System.Windows.Forms.AutoScaleMode.Font;
        this.CancelButton = this.btnCancel;
        this.ClientSize = new System.Drawing.Size( 372, 492 );
        this.Controls.Add( this.btnCancel );
        this.Controls.Add( this.numIteration );
        this.Controls.Add( this.lblNumIteration );
        this.Controls.Add( this.txtClockResolution );
        this.Controls.Add( this.lblClockResolution );
        this.Controls.Add( this.tabConfig );
        this.Controls.Add( this.btnExecute );
        this.Controls.Add( this.btnReferenceBrowse );
        this.Controls.Add( this.txtReference );
        this.Controls.Add( this.lblReference );
        this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.FixedDialog;
        this.MaximizeBox = false;
        this.MinimizeBox = false;
        this.Name = "Pitch_and_Volume_Adjuster";
        this.ShowIcon = false;
        this.ShowInTaskbar = false;
        this.StartPosition = System.Windows.Forms.FormStartPosition.CenterParent;
        this.Text = "Pitch and Volume Adjuster";
        this.groupFormantoWindowWidth.ResumeLayout( false );
        this.groupFormantoWindowWidth.PerformLayout();
        this.tabConfig.ResumeLayout( false );
        this.tabFormanto.ResumeLayout( false );
        this.tabFormanto.PerformLayout();
        this.groupVocaloidWave.ResumeLayout( false );
        this.groupVocaloidWave.PerformLayout();
        this.groupUserWave.ResumeLayout( false );
        this.groupUserWave.PerformLayout();
        this.tabVolume.ResumeLayout( false );
        this.tabVolume.PerformLayout();
        ((System.ComponentModel.ISupportInitialize)(this.numIteration)).EndInit();
        this.groupVolumeWindowWidth.ResumeLayout( false );
        this.groupVolumeWindowWidth.PerformLayout();
        this.ResumeLayout( false );
        this.PerformLayout();

    }
    #endregion

    private void btnReferenceBrowse_Click( object sender, System.EventArgs e ) {
        if ( openWaveDialog.ShowDialog() == System.Windows.Forms.DialogResult.OK ) {
            txtReference.Text = openWaveDialog.FileName;
            btnExecute.Enabled = true;
        }
    }

    private void btnExecute_Click( object sender, System.EventArgs e ) {
        this.DialogResult = System.Windows.Forms.DialogResult.OK;
        this.Close();
    }

    private void txtClockResolution_TextChanged( object sender, System.EventArgs e ) {
        int n = m_clock_resolution;
        if ( int.TryParse( txtClockResolution.Text, out n ) ) {
            if ( n > 0 ) {
                m_clock_resolution = n;
            }
        }
    }

    private void txtUserPeakDetectionThreshold_TextChanged( object sender, System.EventArgs e ) {
        double n = m_user_peak_detection_threshold;
        if ( double.TryParse( txtUserPeakDetectionThreshold.Text, out n ) ) {
            m_user_peak_detection_threshold = n;
        }
    }

    private void txtUserMovingAverageWidth_TextChanged( object sender, System.EventArgs e ) {
        double n = m_user_moving_average_width;
        if ( double.TryParse( txtUserMovingAverageWidth.Text, out n ) ) {
            m_user_moving_average_width = n;
        }
    }

    private void txtVocaloidPeakDetectionThreshold_TextChanged( object sender, System.EventArgs e ) {
        double n = m_vocaloid_peak_detection_threshold;
        if ( double.TryParse( txtVocaloidPeakDetectionThreshold.Text, out n ) ) {
            m_vocaloid_peak_detection_threshold = n;
        }
    }

    private void txtVocaloidMovingAverageWidth_TextChanged( object sender, System.EventArgs e ) {
        double n = m_vocaloid_moving_average_width;
        if ( double.TryParse( txtVocaloidMovingAverageWidth.Text, out n ) ) {
            m_vocaloid_moving_average_width = n;
        }
    }

}
